#include "Cbob.h"

#include <stdlib.h>
#include <stdio.h>

#include "Texture.h"

#include <math.h>

struct sample_MATERIAL{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat emission[3];
 GLfloat alpha;
 GLfloat phExp;
 int   texture;
};

void MyMaterial(GLenum mode,GLfloat *f,GLfloat alpha)
{
 GLfloat d[4];
 d[0]=f[0];
 d[1]=f[1];
 d[2]=f[2];
 d[3]=alpha;
 glMaterialfv (GL_FRONT_AND_BACK,mode,d);
}

void SelectMaterial(int i,sample_MATERIAL *materials)
{
  //
  // Define the reflective properties of the 3D Object faces.
  //
  GLfloat alpha=materials[i].alpha;
  MyMaterial (GL_AMBIENT, materials[i].ambient,alpha);
  MyMaterial (GL_DIFFUSE, materials[i].diffuse,alpha);
  MyMaterial (GL_SPECULAR, materials[i].specular,alpha);
  MyMaterial (GL_EMISSION, materials[i].emission,alpha);
  glMaterialf (GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
};

Cbob::Cbob()
{
    objId=0xFFFFFFFF;
}

Cbob::~Cbob()
{
    clear();
}

typedef GLfloat VERTEXES[3];
typedef GLfloat TEXCOORD[2];

//Chargement d'objet non textur (tx ty tz est le dcallage de l'objet par rapport au centre)
bool Cbob::loadObj(char *fname,float scale,float tx,float ty,float tz)
{
    if(objId==0xFFFFFFFF)clear();
    FILE *g=fopen(fname,"rb");
    if(!g)return false;
    
    sample_MATERIAL *materials;
    unsigned short a_face_indicies[6];
    VERTEXES *vertices;
    VERTEXES *normals;
    
    bool blendAct=false;
    
    unsigned int i,j,k,nbMat,vi,ni;
    
    fread(&nbMat,sizeof(unsigned int),1,g);
    materials=new sample_MATERIAL[nbMat];
    fread(materials,sizeof(sample_MATERIAL),nbMat,g);
    
    fread(&j,sizeof(unsigned int),1,g);
    vertices=new VERTEXES[j];
    for(i=0;i<j;i++)fread(vertices[i],sizeof(GLfloat),3,g);
    
    fread(&j,sizeof(unsigned int),1,g);
    normals=new VERTEXES[j];
    for(i=0;i<j;i++)fread(normals[i],sizeof(GLfloat),3,g);
    
    fread(&nbMat,sizeof(unsigned int),1,g);
    
    float tax,tay,taz;
    
    GLint lid=glGenLists(1);
    glNewList(lid, GL_COMPILE);
    
      for(i=0;i<nbMat;i++)
       {
           
        fread(&k,sizeof(unsigned int),1,g);
        SelectMaterial(k,materials);
            
        if(materials[k].alpha<1.0)
        {
            if(!blendAct)
            {
                glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);//SMOKE
                glEnable(GL_BLEND);
                blendAct=true;
            }
        }
        else if(blendAct)
        {
            blendAct=false;
            glDisable(GL_BLEND);
        }
        
        fread(&k,sizeof(unsigned int),1,g);
            
        glBegin (GL_TRIANGLES);
        
        while(k>0)
        {
            k--;
            fread(a_face_indicies,sizeof(short),6,g);
            for(j=0;j<3;j++)
            {
              vi=a_face_indicies[j];
              ni=a_face_indicies[j+3];//Normal index
              //int ti=a_face_indicies[j+6];//Texture index
                glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
                glVertex3f (vertices[vi][0]*scale+tx,vertices[vi][1]*scale+ty,vertices[vi][2]*scale+tz);
            }
        }
        
        glEnd ();
       }
    
    if(blendAct)
    {
        glDisable(GL_BLEND);
    }
    
    glEndList();
    
    objId=lid;
    
    fclose(g);
    
    delete []normals;
    delete []vertices;
    delete []materials;
    
    return true;
}

//Chargement d'objet textur
bool Cbob::loadObjT(char *fname,float scale,float tx,float ty,float tz)
{
    if(objId==0xFFFFFFFF)clear();
    FILE *g=fopen(fname,"rb");
    if(!g)return false;
    
    sample_MATERIAL *materials;
    unsigned short a_face_indicies[9];
    VERTEXES *vertices;
    VERTEXES *normals;
    
    bool blendAct=false;
    
    unsigned int i,j,k,nbMat,vi,ni;
    
    //char rectifAxe[3][3];
    //for(i=0;i<3;i++)fread(rectifAxe[i],sizeof(char),3,g);
    
    fread(&nbMat,sizeof(unsigned int),1,g);
    materials=new sample_MATERIAL[nbMat];
    fread(materials,sizeof(sample_MATERIAL),nbMat,g);
    
    fread(&j,sizeof(unsigned int),1,g);
    vertices=new VERTEXES[j];
    for(i=0;i<j;i++)fread(vertices[i],sizeof(GLfloat),3,g);
    
    fread(&j,sizeof(unsigned int),1,g);
    normals=new VERTEXES[j];
    for(i=0;i<j;i++)fread(normals[i],sizeof(GLfloat),3,g);
    
    TEXCOORD *textures;
    fread(&j,sizeof(unsigned int),1,g);
    textures=new TEXCOORD[j];
    for(i=0;i<j;i++)fread(textures[i],sizeof(GLfloat),2,g);
    
    fread(&nbMat,sizeof(unsigned int),1,g);
    
    float tax,tay,taz;
    
    GLint lid=glGenLists(1);
    glNewList(lid, GL_COMPILE);
    
    for(i=0;i<nbMat;i++)
   {
        
    fread(&k,sizeof(unsigned int),1,g);
    SelectMaterial(k,materials);
        
    if(materials[k].alpha<1.0)
    {
        if(!blendAct)
        {
            glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);//SMOKE
            glEnable(GL_BLEND);
            blendAct=true;
        }
    }
    else if(blendAct)
    {
        blendAct=false;
        glDisable(GL_BLEND);
    }
    
    fread(&k,sizeof(unsigned int),1,g);
        
    glBegin (GL_TRIANGLES);
    
    while(k>0)
    {
        k--;
        fread(a_face_indicies,sizeof(short),9,g);
        for(j=0;j<3;j++)
        {
          vi=a_face_indicies[j];
          ni=a_face_indicies[j+3];//Normal index
           int ti=a_face_indicies[j+6];//Texture index
           
            glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
            glTexCoord2f(textures[ti][0],textures[ti][1]);
            glVertex3f (vertices[vi][0]*scale+tx,vertices[vi][1]*scale+ty,vertices[vi][2]*scale+tz);
        }
    }
    
    glEnd ();
   }
   delete []textures;
    
    if(blendAct)
    {
        glDisable(GL_BLEND);
    }
    
    glEndList();
    
    objId=lid;
    
    fclose(g);
    
    delete []normals;
    delete []vertices;
    delete []materials;
    
    return true;
}

//cette classe supprime l'objet charge
void Cbob::clear()
{
    if(objId!=0xFFFFFFFF)
    {
        glDeleteLists(objId,1);
        objId=0xFFFFFFFF;
    }
}

void Cbob::draw()
{
    glDisable(GL_TEXTURE_2D);
    if(objId!=0xFFFFFFFF)glCallList(objId);
}








//Cette classe fera forcment appel  loadObjT car elle gre a texture
//mais il peut arriver que l'on ai besoin d'avoir un objet textur
//sans qu'il ai une texture fixe donc on peut le charger comme un objet
//non textur mais avec les coordonnes de textures pour choisir la texture
//au moment voulu.
CbobTex::CbobTex()
{
    texId=0xFFFFFFFF;
}

CbobTex::~CbobTex(){}

bool CbobTex::loadObj(char *fname,GLuint texId,float scale,float tx,float ty,float tz)
{
    this->texId=texId;
    return Cbob::loadObjT(fname,scale,tx,ty,tz);
}

void CbobTex::draw()
{
    if(texId!=0xFFFFFFFF)
    {
     glEnable(GL_TEXTURE_2D);
     glBindTexture( GL_TEXTURE_2D, texId );
    }
    else glDisable(GL_TEXTURE_2D);
    if(objId!=0xFFFFFFFF)glCallList(objId);
}



//Cette classe hrite de l'object texture mais elle n'est pas
//charge de librer l'objet 3D OpenGL comme a on peut
//avoir des prototype qui se charge de les dtruires et l'on peut
//faire des rfrences sans risquer de supprimer un objet 3D dj utilis alleur
//on centralise la gestion des objets 3D comme pour les textures.
CbobRefTex::CbobRefTex(){texId=objId=0xFFFFFFFF;}
CbobRefTex::CbobRefTex(Cbob *bob,GLuint texId)
{
    this->objId=bob->objId;
    this->texId=texId;
}

CbobRefTex::~CbobRefTex(){}

void CbobRefTex::clear()
{
    texId=objId=0xFFFFFFFF;
}






//Binary object Oriented
CbobOBJ::CbobOBJ()
{
    bob=NULL;
    
    //Matrice d'identite pour le moment
    mtx.c.c41=mtx.c.c42=mtx.c.c43=0.0;
    mtx.c.c44=1.0;
    
    mtx.c.c14=0.0;
    mtx.c.c24=0.0;
    mtx.c.c34=0.0;
    
    mtx.c.c11=1.0;
    mtx.c.c21=0.0;
    mtx.c.c31=0.0;
    
    mtx.c.c12=0.0;
    mtx.c.c22=1.0;
    mtx.c.c32=0.0;
    
    mtx.c.c13=0.0;
    mtx.c.c23=0.0;
    mtx.c.c33=1.0;
}

CbobOBJ::~CbobOBJ()
{
    clear();
}

bool CbobOBJ::loadObj(Cbob *bob)
{
    this->bob=bob;
}
/*
bool CbobOBJ::loadObj(char *fname,float scale,float tx,float ty,float tz)
{
    clear();
    bob=new Cbob();
    if(!(bob->loadObj(fname,scale,tx,ty,tz)))clear();
}

bool CbobOBJ::loadObj(char *fname,GLuint texId,float scale,float tx,float ty,float tz)
{
    clear();
    bob=new CbobTex();
    if(!(((CbobTex*)bob)->loadObj(fname,texId,scale,tx,ty,tz)))clear();
}
*/
void CbobOBJ::clear()
{
    if(bob)
    {
        //delete bob;
        bob=NULL;
    }
}

void CbobOBJ::setPosition(float px,float py,float pz)
{
    mtx.c.c14=px;
    mtx.c.c24=py;
    mtx.c.c34=pz;
}

void CbobOBJ::setPositionZ(float pz)
{
    mtx.c.c34=pz;
}

//s'oriente vers une direction
void CbobOBJ::setOrientation(float vx,float vy,float vz,bool inv)
{
    {
        float fl=vx*vx+vy*vy+vz*vz;
        if(fl>0.0)
        {
            fl=sqrtf(fl);
            vx/=fl;
            vy/=fl;
            vz/=fl;
        }
    }
    setOrientationN(vx,vy,vz,inv);
}

//suppose vx,vy,vz dja normalis
void CbobOBJ::setOrientationN(float vx,float vy,float vz,bool inv)
{
    Vecteur dir(vx,vy,vz);
    //dir.normalize();
    Vecteur up;
    
    float t,t2;
    
    t=((vx>=0.0)?(vx):(-vx)); // X
    t2=((vy>=0.0)?(vy):(-vy)); // Y
    
    if(t<t2) // X est mieux
    {
        up.y=0.0;
        t2=((vz>=0.0)?(vz):(-vz)); // Z
        if(t<=t2){up.x=(inv?-1.0:1.0);up.z=0.0;} // X est mieux
        else{up.x=0.0;up.z=(inv?-1.0:1.0);} // Z est mieux
    }
    else // Y est mieux
    {
        up.x=0.0;
        t=t2;
        t2=((vz>=0.0)?(vz):(-vz)); // Z
        if(t<=t2){up.y=(inv?-1.0:1.0);up.z=0.0;} // Y est mieux
        else{up.y=0.0;up.z=(inv?-1.0:1.0);} // Z est mieux
    }
    
    Vecteur X(up);
    X.cross(dir);
    X.normalize();
    up=dir;
    up.cross(X);
    
    mtx.c.c11=X.x;
    mtx.c.c21=X.y;
    mtx.c.c31=X.z;
    
    mtx.c.c12=up.x;
    mtx.c.c22=up.y;
    mtx.c.c32=up.z;
    
    mtx.c.c13=dir.x;
    mtx.c.c23=dir.y;
    mtx.c.c33=dir.z;
}

#include <math.h>

//yawn pitch roll
void CbobOBJ::setRotation(float angleX,float angleY,float angleZ)
{
    float XCos,XSin;
    float YCos,YSin;
    float ZCos,ZSin;
    
    float XCosYSin,XSinYSin;
    
    XCos = cosf(angleX);
    XSin = sinf(angleX);
    YCos = cosf(angleY);
    YSin = sinf(angleY);
    ZCos = cosf(angleZ);
    ZSin = sinf(angleZ);
    
    XCosYSin = XCos * YSin;
    XSinYSin = XSin * YSin;
    
    mtx.c.c11=YCos * ZCos;
    mtx.c.c21=-YCos * ZSin;
    mtx.c.c31=-YSin;
    
    mtx.c.c12=-XSinYSin * ZCos + XCos * ZSin;
    mtx.c.c22=XSinYSin * ZSin + XCos * ZCos;
    mtx.c.c32=-XSin * YCos;
    
    mtx.c.c13=XCosYSin * ZCos + XSin * ZSin;
    mtx.c.c23=-XCosYSin * ZSin + XSin * ZCos;
    mtx.c.c33=XCos * YCos;
}

// obtenir les axes de la nouvelles base de l'objet
void CbobOBJ::getAxeX(Vecteur &r)
{
    r.x=mtx.c.c11;
    r.y=mtx.c.c21;
    r.z=mtx.c.c31;
}

void CbobOBJ::getAxeY(Vecteur &r)
{
    r.x=mtx.c.c12;
    r.y=mtx.c.c22;
    r.z=mtx.c.c32;
}

void CbobOBJ::getAxeZ(Vecteur &r)
{
    r.x=mtx.c.c13;
    r.y=mtx.c.c23;
    r.z=mtx.c.c33;
}

void CbobOBJ::multVect(Vecteur &r,Vecteur v)
{
    r.x=v.x*mtx.c.c11+v.y*mtx.c.c12+v.z*mtx.c.c13;
    r.y=v.x*mtx.c.c21+v.y*mtx.c.c22+v.z*mtx.c.c23;
    r.z=v.x*mtx.c.c31+v.y*mtx.c.c32+v.z*mtx.c.c33;
}

/*
void CbobOBJ::setRotationQuat(float angleX,float angleY,float angleZ)
{
    float sin_a,cos_b;
    
    float x,y,z,w;
}
*/

//dessiner l'objet en appliquant a matrice de rotation et translation actuelle
void CbobOBJ::draw()
{
    if(bob)
    {
        glPushMatrix();
        glMultMatrixf(mtx.m);
        bob->draw();
        glPopMatrix();
    }
}

//dessiner en mtant  jour la position
void CbobOBJ::draw(float px,float py,float pz)
{
    if(bob)
    {
        mtx.c.c14=px;
        mtx.c.c24=py;
        mtx.c.c34=pz;
        glPushMatrix();
        glMultMatrixf(mtx.m);
        bob->draw();
        glPopMatrix();
    }
}

// ajouter la position de l'objet  ce vecteur
void CbobOBJ::addPos(Vecteur &p)
{
    p.x+=mtx.c.c14;
    p.y+=mtx.c.c24;
    p.z+=mtx.c.c34;
}

//obtenir juste la position en Y de l'objet
float CbobOBJ::getPosY()
{
    return mtx.c.c24;
}

// la matrice de l'objet
void CbobOBJ::applyMatrix()
{
    glMultMatrixf(mtx.m);
}






//Classe des prototypes
CPrototypesBobs::CPrototypesBobs()
{
    nbBob=0;
    tabBob=NULL;
}

CPrototypesBobs::~CPrototypesBobs()
{
    clear();
}

//On a 3 types de prototypes
//non textur
//texture
//rfrenc des non textures pour avoir plusieur modle sans les rechargers mais juste changer la texture

#define nbProtoNT 12
#define nbProtoT  12
#define nbProtoRef  10

//nom=nom du fichier .bob   texCord si l'on charge les coordonnes de l'objet bob.
struct SNT{char *nm;float Scale;bool texCord;};

SNT nmProtoNT[nbProtoNT]={
    {".\\Media\\Projectils\\laser.bob",1.6,true},
    {".\\Media\\Projectils\\laser.bob",5.0,true},
    
    {".\\Media\\Projectils\\missile1.bob",8.0,false},//r=0.514315
    {".\\Media\\Projectils\\missile2.bob",8.5,false},//r=0.514315
    {".\\Media\\Projectils\\missile3.bob",8.9,false},//r=0.514315
    {".\\Media\\Projectils\\missile4.bob",9.0,false},//r=0.514315
    {".\\Media\\Projectils\\missile5.bob",10.0,false},//r=0.514315
    
    {".\\Media\\Ship\\3dm-narncrsr.bob",16.0,false},
    
    {".\\Media\\Ship\\3dm-tie-def.bob",SCL_SHIP2,false},
    {".\\Media\\Ship\\3dm-tie-sci.bob",SCL_SHIP3,false},
    {".\\Media\\Ship\\3dm-t-invadr.bob",SCL_SHIP4,false},
    {".\\Media\\Ship\\3dm-vad-tie.bob",SCL_SHIP5,false}
};

//nom=nom du fichier .bob   nmT=nom texture
struct ST{char *nm;char *nmT;float Scale;};

//{".\\Media\\Avions\\furtifH.bob",".\\Media\\Avions\\furtifH.bmp",16.0},//r=0.521946

ST nmProtoT[nbProtoT]={
    {".\\Media\\Ship\\furtifH.bob",".\\Media\\Ship\\furtifH.bmp",SCL_SHIP6}, //r=0.514565
    {".\\Media\\Ship\\furtifE.bob",".\\Media\\Ship\\furtifE.bmp",SCL_SHIP7}, //r=0.514565
    {".\\Media\\Ship\\Chasseur1.bob",".\\Media\\Ship\\Chasseur1.bmp",SCL_SHIP8}, //r=0.514565
    {".\\Media\\Ship\\Chasseur2.bob",".\\Media\\Ship\\Chasseur2.bmp",SCL_SHIP9}, //r=0.514565
    {".\\Media\\Fixe\\Launcher\\Launch1Base.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_LAUNCHER1*1.4},
    {".\\Media\\Fixe\\Launcher\\Launch1Neck.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_LAUNCHER1},
    {".\\Media\\Fixe\\Launcher\\Launch1Head.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_LAUNCHER1},
    {".\\Media\\Fixe\\Launcher\\Launch1HeadBits.bob",".\\Media\\Fixe\\Launcher\\Launcher1H.bmp",SCL_LAUNCHER1},
    {".\\Media\\Fixe\\TourelleLaser\\Turret1Base.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_TURRET1*1.2},
    {".\\Media\\Fixe\\TourelleLaser\\Turret1Neck.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_TURRET1},
    {".\\Media\\Fixe\\TourelleLaser\\Turret1Head.bob",".\\Media\\Fixe\\Launcher\\Launcher1N.bmp",SCL_TURRET1},
    {".\\Media\\Fixe\\TourelleLaser\\Turret1HeadBits.bob",".\\Media\\Fixe\\TourelleLaser\\turretHole.bmp",SCL_TURRET1}
};

//Le id est la rfrence dans les objets prototypes
//nmT = nom de la texture
struct SRef{unsigned char id;char *nmT;};

SRef nmProtoRef[nbProtoRef]={
    {0,"LASER_BLUE_TEX_PROC"},
    {0,"LASER_RED_TEX_PROC"},
    {0,"LASER_GREEN_TEX_PROC"},
    {0,"LASER_CYAN_TEX_PROC"},
    {0,"LASER_YELLOW_TEX_PROC"},
    
    {1,"LASER_BLUE_TEX_PROC"},
    {1,"LASER_RED_TEX_PROC"},
    {1,"LASER_GREEN_TEX_PROC"},
    {1,"LASER_CYAN_TEX_PROC"},
    {1,"LASER_YELLOW_TEX_PROC"}
};

//Charger les prototypes
void CPrototypesBobs::initPrototypes()
{
    nbBob=nbProtoNT+nbProtoT+nbProtoRef;
    tabBob=new Cbob*[nbBob];
    unsigned char i;
    //for(i=0;i<nbBob;i++)tabBob[i]=NULL;
    
    Cbob **ptr=tabBob;
    
    for(i=0;i<nbProtoNT;i++)
    {
        *ptr=new Cbob;
        
        if(nmProtoNT[i].texCord)
            (*ptr)->loadObjT(nmProtoNT[i].nm,nmProtoNT[i].Scale);
        else (*ptr)->loadObj(nmProtoNT[i].nm,nmProtoNT[i].Scale);
        
        ptr++;
    }
    
    for(i=0;i<nbProtoT;i++)
    {
        *ptr=new CbobTex;
        ((CbobTex*)(*ptr))->loadObj(nmProtoT[i].nm,CTexture::GetInstance()->getTexture(nmProtoT[i].nmT),nmProtoT[i].Scale);
        ptr++;
    }
    
    for(i=0;i<nbProtoRef;i++)
    {
        *ptr=new CbobRefTex(tabBob[nmProtoRef[i].id],CTexture::GetInstance()->getTexture(nmProtoRef[i].nmT));
        ptr++;
    }
}

//Dcharger les prototypes
void CPrototypesBobs::clear()
{
    if(tabBob)
    {
        unsigned char i;
        for(i=0;i<nbBob;i++)if(tabBob[i])delete tabBob[i];
        delete []tabBob;
        tabBob=NULL;
    }
}

//Obtenir un modles d'indice id
Cbob *CPrototypesBobs::getPrototype(unsigned char id)
{
    if(id<nbBob)return tabBob[id];
    return NULL;
}
